<?php
// Iegūst reģistrācijas datus
$email = $_POST['email'];
$user = $_POST['user'];
$password = $_POST['password'];
$password_confirm = $_POST['confirm_password'];

// Pārbauda, vai nav tukšu lauku un, ja ir, atjauno lapu
if(empty($email) || empty($user) || empty($password) || empty($password_confirm)) {
    header("Location: https://lasitava.000webhostapp.com/register/register.php"); 
    exit;
}

// Pārbauda e-pasta adreses formātu
if( ! filter_var($_POST["email"], FILTER_VALIDATE_EMAIL)) {
    // Ja e-pasta adrese nav pareiza, izvada paziņojumu par nederīgu e-pasta adresi un atjauno lapu
    echo '<script>
    alert("Lūdzu uzrakstiet pareiza formāta e-pasta adresi.");
    setTimeout(function() {
        window.location.href = "https://lasitava.000webhostapp.com/register/register.php";
    }, 0);
    </script>';
    exit;
}

// Pārbauda paroles garumu
if(strlen($password) < 8) {
    // Ja parole ir par īsu, izvada paziņojumu un atjauno lapu
    echo '<script>
    alert("Parolei ir jāsastāv vismaz no 8 simboliem.");
    setTimeout(function() {
        window.location.href = "https://lasitava.000webhostapp.com/register/register.php";
    }, 0);
    </script>';
    exit;
}

// Pārbauda, vai paroles sakrīt
if($password !== $password_confirm) {
    // Ja paroles nesakrīt, izvada paziņojumu un atjauno lapu
    echo '<script>
    alert("Paroles nesakrīt.");
    setTimeout(function() {
        window.location.href = "https://lasitava.000webhostapp.com/register/register.php";
    }, 0);
    </script>';
    exit;
}

// Nodrošina paroli, izmantojot "hešu"
$password_hash = password_hash($password, PASSWORD_DEFAULT);

// Izveido savienojumu ar datubāzi
$mysqli = require __DIR__ . "/../db/database.php";

// Pārbauda, vai e-pasts jau nav reģistrēts
$sql_check_email = "SELECT * FROM users WHERE email = ?";
$stmt_check_email = $mysqli->prepare($sql_check_email);
$stmt_check_email->bind_param("s", $email);
$stmt_check_email->execute();
$result_check_email = $stmt_check_email->get_result();

// Ja e-pasts jau ir reģistrēts, izvada paziņojumu un atjauno lapu
if ($result_check_email->num_rows > 0) {
    echo '<script>
            alert("E-pasts ' . $email . ' ir jau piereģistrēts.");
            setTimeout(function() {
                window.location.href = "https://lasitava.000webhostapp.com/register/register.php";
            }, 0);
          </script>';
    exit;
} 

// Pārbauda, vai lietotājvārds jau nav reģistrēts
$sql_check_username = "SELECT * FROM users WHERE username = ?";
$stmt_check_username = $mysqli->prepare($sql_check_username);
$stmt_check_username->bind_param("s", $user);
$stmt_check_username->execute();
$result_check_username = $stmt_check_username->get_result();

// Ja lietotājvārds jau ir reģistrēts, izvada paziņojumu un atjauno lapu
if ($result_check_username->num_rows > 0) {
    echo '<script>
            alert("Lietotājvārds ' . $user . ' ir jau piereģistrēts.");
            setTimeout(function() {
                window.location.href = "https://lasitava.000webhostapp.com/register/register.php";
            }, 0);
        </script>';
    exit;
} 

// Ievieto jauno lietotāju datubāzē
$sql_insert_user = "INSERT INTO users(email, username, password_hash, id_access) VALUES (?, ?, ?, 2)";
$stmt_insert_user = $mysqli->prepare($sql_insert_user);
$stmt_insert_user->bind_param("sss", 
                              $email, 
                              $user, 
                              $password_hash);

try {
    // Mēģina izpildīt pieprasījumu
    $stmt_insert_user->execute();
    // Ja izdevies, izvada paziņojumu un novirza lietotāju uz sākumlapu
    echo '<script>
            alert("Lietotājs ' . $user . ' ir veiksmīgi piereģistrēts!");
            setTimeout(function() {
                window.location.href = "https://lasitava.000webhostapp.com/homepage/homepage.php";
            }, 0); 
         </script>';
    exit; 
} catch (Exception $e) {
    // Ja ir kļūda, izvada kļūdas ziņojumu
    echo "Exception: " . $e->getMessage();
}
